/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.patcher.impl;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.bukkit.Material;
import org.magmafoundation.magma.patcher.Patcher;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@Patcher.PatcherInfo(name="WorldEdit", description="Patches WorldEdit")
public class WorldEditPatcher
extends Patcher {
    @Override
    public byte[] transform(String className, byte[] basicClass) {
        switch (className) {
            case "com.sk89q.worldedit.bukkit.WorldEditPlugin": {
                System.setProperty("worldedit.bukkit.adapter", "com.sk89q.worldedit.bukkit.adapter.impl.v1_18_R2.PaperweightAdapter");
                return this.patchWorldEditPlugin(basicClass);
            }
            case "com.sk89q.worldedit.bukkit.BukkitAdapter": {
                return this.patchBukkitAdapter(basicClass);
            }
            case "com.sk89q.worldedit.bukkit.adapter.impl.v1_18_R2.PaperweightAdapter": {
                return this.patchSpigot_v1_18_R2(basicClass);
            }
        }
        return basicClass;
    }

    public static Material adaptHook(String type) {
        Preconditions.checkNotNull((Object)type);
        return Material.getMaterial((!type.startsWith("minecraft:") ? type.replace(":", "_") : type.substring(10)).toUpperCase(Locale.ROOT));
    }

    private byte[] patchWorldEditPlugin(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode methodNode : node.methods) {
            this.injectGetKeyForge(methodNode);
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchBukkitAdapter(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode methodNode : node.methods) {
            InsnList insnList;
            if (methodNode.name.equals("adapt") && methodNode.desc.equals("(Lcom/sk89q/worldedit/world/block/BlockType;)Lorg/bukkit/Material;")) {
                insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insnList.add((AbstractInsnNode)new MethodInsnNode(182, "com/sk89q/worldedit/world/block/BlockType", "getId", "()Ljava/lang/String;"));
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(WorldEditPatcher.class), "adaptHook", "(Ljava/lang/String;)Lorg/bukkit/Material;"));
                insnList.add((AbstractInsnNode)new InsnNode(176));
                methodNode.instructions = insnList;
            }
            if (methodNode.name.equals("adapt") && methodNode.desc.equals("(Lcom/sk89q/worldedit/world/item/ItemType;)Lorg/bukkit/Material;")) {
                insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insnList.add((AbstractInsnNode)new MethodInsnNode(182, "com/sk89q/worldedit/world/item/ItemType", "getId", "()Ljava/lang/String;"));
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(WorldEditPatcher.class), "adaptHook", "(Ljava/lang/String;)Lorg/bukkit/Material;"));
                insnList.add((AbstractInsnNode)new InsnNode(176));
                methodNode.instructions = insnList;
            }
            this.injectGetKeyForge(methodNode);
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void injectGetKeyForge(MethodNode methodNode) {
        for (AbstractInsnNode insnNode : methodNode.instructions) {
            if (!(insnNode instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
            if (!methodInsnNode.owner.equals("org/bukkit/Material") || !methodInsnNode.name.equals("getKey") || !methodInsnNode.desc.equals("()Lorg/bukkit/NamespacedKey;")) continue;
            methodInsnNode.name = "getKeyForge";
        }
    }

    private byte[] patchSpigot_v1_18_R2(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode methodNode : node.methods) {
            if (!methodNode.name.equals("getProperties") || !methodNode.desc.equals("(Lcom/sk89q/worldedit/world/block/BlockType;)Ljava/util/Map;")) continue;
            for (AbstractInsnNode insnNode : methodNode.instructions) {
                if (!(insnNode instanceof InsnNode) || insnNode.getOpcode() != 191) continue;
                InsnList insnList = new InsnList();
                insnList.add((AbstractInsnNode)new InsnNode(87));
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, "java/util/Collections", "emptyMap", "()Ljava/util/Map;"));
                insnList.add((AbstractInsnNode)new InsnNode(176));
                methodNode.instructions.insertBefore(insnNode, insnList);
                methodNode.instructions.remove(insnNode);
                break block0;
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

